<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/utils.php';

$code = trim($_GET['code'] ?? '');
$guest = null;
if ($code !== '') {
  $stmt = $db->prepare("SELECT g.name, g.code, gs.checked_in_at, gs.souvenir_at
                        FROM guests g JOIN guest_status gs ON gs.guest_id = g.id
                        WHERE g.code = ? LIMIT 1");
  $stmt->execute([$code]);
  $guest = $stmt->fetch();
}

require __DIR__ . '/_header.php';
?>
<div class="row justify-content-center">
  <div class="col-12 col-lg-6">
    <div class="card shadow-sm">
      <div class="card-body">
        <h1 class="h5 mb-3">QR Lookup (Publik)</h1>
        <form method="get" class="d-flex gap-2">
          <input class="form-control" name="code" placeholder="Masukkan CODE QR" value="<?= h($code) ?>">
          <button class="btn btn-outline-primary">Cek</button>
        </form>

        <?php if ($code === ''): ?>
          <div class="text-secondary mt-3">Masukkan code untuk melihat status tamu.</div>
        <?php elseif (!$guest): ?>
          <div class="alert alert-danger mt-3">Kode tidak ditemukan.</div>
        <?php else: ?>
          <hr>
          <div class="fw-semibold"><?= h($guest['name']) ?></div>
          <div class="small text-secondary">CODE: <code><?= h($guest['code']) ?></code></div>
          <div class="mt-3 d-flex gap-2 flex-wrap">
            <?php if ($guest['checked_in_at']): ?>
              <span class="badge text-bg-success">CHECK-IN: <?= h($guest['checked_in_at']) ?></span>
            <?php else: ?>
              <span class="badge text-bg-secondary">Belum check-in</span>
            <?php endif; ?>

            <?php if ($guest['souvenir_at']): ?>
              <span class="badge text-bg-success">SOUVENIR: <?= h($guest['souvenir_at']) ?></span>
            <?php else: ?>
              <span class="badge text-bg-secondary">Belum ambil souvenir</span>
            <?php endif; ?>
          </div>
          <div class="alert alert-warning mt-3 mb-0">
            Status ini hanya informasi. Untuk validasi check-in/souvenir harus lewat halaman scanner petugas.
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/_footer.php'; ?>
