<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/auth.php';
start_session();

$err = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = trim($_POST['username'] ?? '');
  $password = (string)($_POST['password'] ?? '');
  $token = $_POST['csrf'] ?? '';
  if (!csrf_validate($token)) $err = "CSRF tidak valid. Refresh halaman.";
  else {
    [$ok, $msg] = login($db, $username, $password);
    if ($ok) redirect('/public/scan.php');
    $err = $msg;
  }
}
require __DIR__ . '/_header.php';
?>
<div class="row justify-content-center">
  <div class="col-12 col-md-6 col-lg-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <h1 class="h5 mb-3">Login Petugas</h1>
        <?php if ($err): ?>
          <div class="alert alert-danger"><?= h($err) ?></div>
        <?php endif; ?>
        <form method="post">
          <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
          <div class="mb-2">
            <label class="form-label">Username</label>
            <input class="form-control" name="username" autocomplete="username" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Password</label>
            <input type="password" class="form-control" name="password" autocomplete="current-password" required>
          </div>
          <button class="btn btn-primary w-100">Masuk</button>
          <div class="small text-secondary mt-2">
            Default: <code>scanner/scanner123</code> atau <code>admin/admin123</code>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/_footer.php'; ?>
