<?php
require_once __DIR__ . '/../app/utils.php';
$config = require __DIR__ . '/../app/config.php';
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= h($config['app_name']) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f7f7fb; }
    .card { border-radius: 16px; }
    .btn { border-radius: 12px; }
    .badge { border-radius: 999px; }
    .scanner-box { border: 2px dashed rgba(0,0,0,.2); border-radius: 16px; overflow: hidden; background: #fff; }
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg bg-white border-bottom">
  <div class="container">
    <a class="navbar-brand fw-semibold" href="/public/index.php"><?= h($config['app_name']) ?></a>
    <div class="ms-auto d-flex gap-2">
      <a class="btn btn-outline-secondary btn-sm" href="/public/scan.php">Scanner</a>
      <a class="btn btn-outline-secondary btn-sm" href="/admin/dashboard.php">Admin</a>
    </div>
  </div>
</nav>
<div class="container my-4">
