<?php
require_once __DIR__ . '/utils.php';

// NOTE:
// - check-in hanya sekali
// - souvenir hanya sekali
// - souvenir boleh hanya setelah check-in (aturan default)

function find_guest_by_code(PDO $db, string $code, ?int $eventId=null) {
  if ($eventId) {
    $stmt = $db->prepare("SELECT g.id, g.event_id, g.name, g.code, gs.checked_in_at, gs.souvenir_at
                          FROM guests g
                          JOIN guest_status gs ON gs.guest_id = g.id
                          WHERE g.code = ? AND g.event_id = ?
                          LIMIT 1");
    $stmt->execute([$code, $eventId]);
  } else {
    $stmt = $db->prepare("SELECT g.id, g.event_id, g.name, g.code, gs.checked_in_at, gs.souvenir_at
                          FROM guests g
                          JOIN guest_status gs ON gs.guest_id = g.id
                          WHERE g.code = ?
                          LIMIT 1");
    $stmt->execute([$code]);
  }
  return $stmt->fetch();
}

function log_scan(PDO $db, int $eventId, int $guestId, string $scanType, int $operatorId, string $deviceInfo='') {
  $stmt = $db->prepare("INSERT INTO scan_logs(event_id, guest_id, scan_type, scan_time, operator_id, device_info)
                        VALUES(?, ?, ?, NOW(), ?, ?)");
  $stmt->execute([$eventId, $guestId, $scanType, $operatorId, $deviceInfo]);
}

function scan_checkin(PDO $db, string $code, int $operatorId, ?int $eventId=null, string $deviceInfo='') {
  $guest = find_guest_by_code($db, $code, $eventId);
  if (!$guest) return ['ok'=>false, 'status'=>'NOT_FOUND', 'msg'=>'Kode tidak valid / tamu tidak ditemukan'];

  // Atomic update anti double-scan
  $stmt = $db->prepare("UPDATE guest_status SET checked_in_at = NOW(), checked_in_by = ?
                        WHERE guest_id = ? AND checked_in_at IS NULL");
  $stmt->execute([$operatorId, $guest['id']]);

  if ($stmt->rowCount() === 1) {
    log_scan($db, (int)$guest['event_id'], (int)$guest['id'], 'CHECKIN', $operatorId, $deviceInfo);
    return ['ok'=>true, 'status'=>'CHECKIN_OK', 'msg'=>'CHECK-IN BERHASIL', 'guest'=>$guest['name']];
  }

  return ['ok'=>false, 'status'=>'ALREADY_CHECKEDIN', 'msg'=>'Tamu sudah CHECK-IN sebelumnya', 'guest'=>$guest['name'], 'checked_in_at'=>$guest['checked_in_at']];
}

function scan_souvenir(PDO $db, string $code, int $operatorId, ?int $eventId=null, string $deviceInfo='') {
  $guest = find_guest_by_code($db, $code, $eventId);
  if (!$guest) return ['ok'=>false, 'status'=>'NOT_FOUND', 'msg'=>'Kode tidak valid / tamu tidak ditemukan'];

  if (empty($guest['checked_in_at'])) {
    return ['ok'=>false, 'status'=>'MUST_CHECKIN_FIRST', 'msg'=>'Souvenir hanya boleh setelah CHECK-IN', 'guest'=>$guest['name']];
  }

  $stmt = $db->prepare("UPDATE guest_status SET souvenir_at = NOW(), souvenir_by = ?
                        WHERE guest_id = ? AND souvenir_at IS NULL");
  $stmt->execute([$operatorId, $guest['id']]);

  if ($stmt->rowCount() === 1) {
    log_scan($db, (int)$guest['event_id'], (int)$guest['id'], 'SOUVENIR', $operatorId, $deviceInfo);
    return ['ok'=>true, 'status'=>'SOUVENIR_OK', 'msg'=>'SOUVENIR BERHASIL', 'guest'=>$guest['name']];
  }

  return ['ok'=>false, 'status'=>'ALREADY_SOUVENIR', 'msg'=>'Souvenir sudah pernah diambil', 'guest'=>$guest['name'], 'souvenir_at'=>$guest['souvenir_at']];
}
