<?php
$config = require __DIR__ . '/config.php';
date_default_timezone_set($config['timezone']);

$dbConf = $config['db'];
$dsn = sprintf('mysql:host=%s;port=%d;dbname=%s;charset=%s',
  $dbConf['host'],
  $dbConf['port'],
  $dbConf['name'],
  $dbConf['charset']
);

$options = [
  PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
  $db = new PDO($dsn, $dbConf['user'], $dbConf['pass'], $options);
} catch (Throwable $e) {
  http_response_code(500);
  header('Content-Type: text/plain; charset=utf-8');
  echo "DB connection error: " . $e->getMessage();
  exit;
}
