<?php
require_once __DIR__ . '/utils.php';

function start_session() {
  $config = require __DIR__ . '/config.php';
  if (session_status() === PHP_SESSION_NONE) {
    session_name($config['session_name']);
    session_start();
  }
}

function require_login() {
  start_session();
  if (empty($_SESSION['user'])) {
    redirect('/public/login.php');
  }
}

function current_user() {
  start_session();
  return $_SESSION['user'] ?? null;
}

function login(PDO $db, string $username, string $password) {
  $stmt = $db->prepare("SELECT id, username, password_hash, role, event_id FROM users WHERE username = ? LIMIT 1");
  $stmt->execute([$username]);
  $u = $stmt->fetch();
  if (!$u) return [false, "Username tidak ditemukan"];
  if (!password_verify($password, $u['password_hash'])) return [false, "Password salah"];
  start_session();
  unset($u['password_hash']);
  $_SESSION['user'] = $u;
  return [true, null];
}

function logout() {
  start_session();
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $p = session_get_cookie_params();
    setcookie(session_name(), '', time()-42000, $p["path"], $p["domain"], $p["secure"], $p["httponly"]);
  }
  session_destroy();
}
