<?php require __DIR__ . '/_header.php'; ?>

<?php
$eventFilter = !empty($u['event_id']) ? " WHERE g.event_id=" . (int)$u['event_id'] . " " : "";
$stats = [
  'total' => 0,
  'checked_in' => 0,
  'souvenir' => 0,
];
$stats['total'] = (int)$db->query("SELECT COUNT(*) c FROM guests g $eventFilter")->fetch()['c'];
$stats['checked_in'] = (int)$db->query("SELECT COUNT(*) c FROM guest_status gs JOIN guests g ON g.id=gs.guest_id $eventFilter AND gs.checked_in_at IS NOT NULL")->fetch()['c'];
$stats['souvenir'] = (int)$db->query("SELECT COUNT(*) c FROM guest_status gs JOIN guests g ON g.id=gs.guest_id $eventFilter AND gs.souvenir_at IS NOT NULL")->fetch()['c'];
?>

<div class="row g-3">
  <div class="col-12 col-lg-8">
    <div class="card shadow-sm">
      <div class="card-body">
        <h1 class="h5 mb-3">Dashboard</h1>
        <div class="row g-3">
          <div class="col-6 col-md-4">
            <div class="p-3 bg-white border rounded-4">
              <div class="text-secondary small">Total Tamu</div>
              <div class="fs-4 fw-semibold"><?= h($stats['total']) ?></div>
            </div>
          </div>
          <div class="col-6 col-md-4">
            <div class="p-3 bg-white border rounded-4">
              <div class="text-secondary small">Sudah Check-in</div>
              <div class="fs-4 fw-semibold"><?= h($stats['checked_in']) ?></div>
            </div>
          </div>
          <div class="col-6 col-md-4">
            <div class="p-3 bg-white border rounded-4">
              <div class="text-secondary small">Sudah Souvenir</div>
              <div class="fs-4 fw-semibold"><?= h($stats['souvenir']) ?></div>
            </div>
          </div>
        </div>

        <hr>
        <div class="d-flex gap-2 flex-wrap">
          <a class="btn btn-primary" href="/admin/guests.php">Kelola Tamu</a>
          <a class="btn btn-outline-primary" href="/admin/export.php">Export CSV</a>
        </div>
      </div>
    </div>
  </div>
  <div class="col-12 col-lg-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <div class="fw-semibold mb-2">Catatan</div>
        <ul class="small text-secondary mb-0">
          <li>Untuk iPhone, pastikan domain sudah HTTPS.</li>
          <li>Anti double-scan sudah aman di level database.</li>
          <li>Souvenir default hanya boleh setelah check-in.</li>
        </ul>
      </div>
    </div>
  </div>
</div>

<?php require __DIR__ . '/_footer.php'; ?>
